# -*- coding: cp1252 -*-


######################################################################
#
# Name:  Collect Maya Versions
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This script creates a batch file that executes a dir/ls command to list all Houdini versions installed on the machine.
#   In addition, it will add known Houdini versions to an excel table
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os



winHoudiniInstallLocation= "C:\\Program Files\\Side Effects Software\\*"
lxHoudiniInstallLocation= "/opt/hfs*"
osxHoudiniInstallLocation= "/Library/Frameworks/Houdini.framework/versions/*"

versionsForTable= []
versionsForTable.append("16.0.736")
versionsForTable.append("16.5.268")
versionsForTable.append("16.5.473")



fileBaseName=rrGlobal.rrRootPath()+"inhouse\\rrCollectHoudiniVersion"
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")


batchF = rrGlobal.getCrossBatch()
batchF.setBaseFileName(fileBaseName)

batchF.osVarAdd("ErrorLevel","%ERRORLEVEL%","$?","$?")  #Note: debian uses $status and not $?
batchF.osVarAdd("rrParseOutput_Exe","rrParseOutput","rrParseOutput","rrParseOutput.app\Contents\MacOS\rrParseOutput")
batchF.osVarAdd("listFiles", "<comspec> /c dir /b", "/bin/ls -1", "/bin/ls -1")
batchF.osVarAdd("InstallLocation", winHoudiniInstallLocation, lxHoudiniInstallLocation, osxHoudiniInstallLocation)

batchF.addLine("<comment> This file was automatically created by a rrSubmitter Scripted Job Plugin ")
batchF.addEnd()

batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('<listFiles>  "<InstallLocation>" ')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
for ver in versionsForTable:
    batchF.addFlag(ver+"=find="+ver)
batchF.addEnd()
batchF.addEnd()
    



if not batchF.saveWin():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveLx():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveOsx():
    raise Exception(batchF.fileErrorMessage())




#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="Houdini Version Check"



newJob=  rr.getNewJob()
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=fileBaseName+"_result.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="Houdini Version Check"

rr.setSubmitterParameter("MaxClientsAtATime=0~5") #too many clients writing to the same csv file might be an issue



rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.